* Provides basic analysis of related surveys

cap program drop labgraph
program define labgraph
	syntax varlist [if]
	marksample touse
	correl `1' `2' `if'
	global rho=string(r(rho),"%4.2f")
	reg `1' `2' `if'
	global b=string(_b[`2'],"%3.2f")
	global a=string(_b[_cons],"%3.2f")
	global se=string(_se[`2'],"%3.2f")
end

*** Kettering, 1975
use "Other surveys\Kettering\Kettering 1975.dta", clear
for var sat* hap*: replace X=X/100
sort cty year
merge cty year using "Processed files\Complete_GDP.dta"
drop if _merge==2
tab cty _merge
drop _merge
la var gdp "GDP per capita, PPP (2000 US$)"
gen lgdp=ln(gdp)

reshape long sat hap, i(cty) j(rating)
egen tag_sat=tag(cty) if sat~=.
xi: oprobit rating i.cty [pw=sat]
predict sathat if rating~=. & sat~=., xb
summ sathat if tag_sat==1
replace sathat=sathat-r(mean)
egen tag_hap=tag(cty) if hap~=.
xi: oprobit rating i.cty [aw=hap]
predict haphat if rating~=. & hap~=., xb
summ haphat if tag_hap==1
replace haphat=haphat-r(mean)

lowess sathat lgdp if tag_sat==1, nograph generate(sathat_low)
reg sathat lgdp if tag_sat==1
predict sathathat if tag_sat==1
labgraph sathat lgdp if tag_sat==1
#delimit ;
twoway
	(scatter sathat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12))
	(line sathathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_sat==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtitle("")
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f) labcolor(white))
	legend(off)
	xsize(10) ysize(7.5)
	name(kettering_sat, replace)
;
#delimit cr

lowess haphat lgdp if tag_hap==1, nograph generate(haphat_low)
reg haphat lgdp if tag_hap==1
predict haphathat if tag_hap==1
labgraph haphat lgdp if tag_hap==1
#delimit ;
twoway
	(scatter haphat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12) )
	(line haphathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_hap==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtick(64000, notick)
	xtitle("")
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	legend(off)
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(kettering_hap, replace)
;
#delimit cr

#delimit ;
graph combine kettering_hap kettering_sat,
	rows(1)
	title("Kettering-Gallup Survey, 1975", size(medium))
	imargin(zero)
	xsize(10) ysize(7.5)
	name(kettering, replace)
;
#delimit cr


*** European Quality of Life Survey
use "Other surveys\European Quality of Life\eqls_version_2", clear

gen wt=wcountry

gen str3 cty=""
replace cty="AUT" if s_cntry==1
replace cty="BEL" if s_cntry==2
replace cty="BGR" if s_cntry==3
replace cty="CYP" if s_cntry==4
replace cty="CZE" if s_cntry==5
replace cty="DNK" if s_cntry==6
replace cty="EST" if s_cntry==7
replace cty="FIN" if s_cntry==8
replace cty="FRA" if s_cntry==9
replace cty="DEU" if s_cntry==10
replace cty="GBR" if s_cntry==11
replace cty="GRC" if s_cntry==12
replace cty="HUN" if s_cntry==13
replace cty="IRL" if s_cntry==14
replace cty="ITA" if s_cntry==15
replace cty="LVA" if s_cntry==16
replace cty="LTU" if s_cntry==17
replace cty="LUX" if s_cntry==18
replace cty="MLT" if s_cntry==19
replace cty="NLD" if s_cntry==20
replace cty="POL" if s_cntry==21
replace cty="ROM" if s_cntry==22
replace cty="SVK" if s_cntry==23
replace cty="SVN" if s_cntry==24
replace cty="ESP" if s_cntry==25
replace cty="SWE" if s_cntry==26
replace cty="TUR" if s_cntry==27
replace cty="PRT" if s_cntry==28

gen year=2003
sort cty year
merge cty year using "Processed files\Complete_GDP"
drop if _merge==2
tab cty if gdp==.
gen lgdp=ln(gdp)
la var gdp "GDP per capita, PPP (2000 US$)"
compress

gen sat=q31
replace sat=. if sat>10
gen hap=q42
replace hap=. if hap>10

xi: oprobit sat i.cty [aw=wt]
predict sathat if sat~=., xb
egen tag_sat=tag(cty) if sat~=.
summ sathat if tag_sat==1
replace sathat=sathat-r(mean)

lowess sathat lgdp if tag_sat==1, nograph generate(sathat_low)
reg sathat lgdp if tag_sat==1
predict sathathat if tag_sat==1
labgraph sathat lgdp if tag_sat==1
#delimit ;
twoway
	(scatter sathat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12))
	(line sathathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_sat==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtitle("")
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f) labcolor(white))
	legend(off)
	xsize(10) ysize(7.5)
	name(euroqol_sat, replace)
;
#delimit cr

xi: oprobit hap i.cty [aw=wt]
predict haphat if hap~=., xb
egen tag_hap=tag(cty) if hap~=.
summ haphat if tag_hap==1
replace haphat=haphat-r(mean)

lowess haphat lgdp if tag_hap==1, nograph generate(haphat_low)
reg haphat lgdp if tag_hap==1
predict haphathat if tag_hap==1
labgraph haphat lgdp if tag_hap==1
#delimit ;
twoway
	(scatter haphat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12))
	(line haphathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_hap==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtick(64000, notick)
	xtitle("")
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	legend(off)
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(euroqol_hap, replace)
;
#delimit cr

#delimit ;
graph combine euroqol_hap euroqol_sat,
	rows(1)
	title("First European Quality of Life Survey, 2003", size(medium))
	imargin(zero)
	xsize(10) ysize(7.5)
	name(euroqol, replace)
;
#delimit cr



*** Eurobarometer Life Sat (66.1)
use "Other surveys\Eurobarometer 66.1\21281-0001-Data.dta", clear
gen wt=W1
gen str3 cty=""
for ! in num 1/32 \ @ in any BEL DNK FRG GDR GRC ESP FIN FRA IRL ITA LUX NLD AUT PRT SWE GBR NIR CYP CZE EST HUN LVA LTU MLT POL SVK SLV BGR ROM TUR HRV CYP: replace cty="@" if COUNTRY==!
replace cty="GBR" if cty=="NIR"
replace wt=W4 if cty=="GBR"
replace wt=. if COUNTRY==32 /*Cyprus TCC*/
gen year=2006
sort cty year
merge cty year using "Processed files\Complete_GDP"
drop if _merge==2
tab cty _merge
drop _merge
la var gdp "Real GDP per capita (2000 US$), PPP (log scale)"
gen lgdp=ln(gdp)

gen sat=5-QA3 if QA1<=4

xi: oprobit sat i.cty [pw=wt]
predict sathat if sat~=., xb
egen tag_sat=tag(cty) if sat~=.
summ sathat if tag_sat==1
replace sathat=sathat-r(mean)

lowess sathat lgdp if tag_sat==1, nograph generate(sathat_low)
reg sathat lgdp if tag_sat==1
predict sathathat if tag_sat==1
labgraph sathat lgdp if tag_sat==1
#delimit ;
twoway
	(scatter sathat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12))
	(line sathathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_sat==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtitle("")
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f) labcolor(white))
	legend(off)
	xsize(10) ysize(7.5)
	name(eurob_sat, replace)
;
#delimit cr

*** Eurobarometer happiness (66.3)
use "Other surveys\Eurobarometer 66.3\21523-0001-Data.dta", clear

gen wt=W1
gen str3 cty=""
for ! in num 1/32 \ @ in any BEL DNK FRG GDR GRC ESP FIN FRA IRL ITA LUX NLD AUT PRT SWE GBR NIR CYP CZE EST HUN LVA LTU MLT POL SVK SLV BGR ROM TUR HRV CYP: replace cty="@" if COUNTRY==!
replace cty="GBR" if cty=="NIR"
replace wt=W4 if cty=="GBR"
replace wt=. if COUNTRY==32 /*Cyprus TCC*/
gen year=2006
sort cty year
merge cty year using "Processed files\Complete_GDP"
drop if _merge==2
tab cty _merge
drop _merge
la var gdp "Real GDP per capita (2000 US$), PPP (log scale)"
gen lgdp=ln(gdp)
gen happy=5-QA1 if QA1<=4

xi: oprobit happy i.cty [pw=wt]
predict haphat if happy~=., xb
egen tag_hap=tag(cty) if happy~=.
summ haphat if tag_hap==1
replace haphat=haphat-r(mean)

lowess haphat lgdp if tag_hap==1, nograph generate(haphat_low)
reg haphat lgdp if tag_hap==1
predict haphathat if tag_hap==1
labgraph haphat lgdp if tag_hap==1
#delimit ;
twoway
	(scatter haphat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy) mlabpos(12))
	(line haphathat gdp, sort lpattern(longdash) lcolor(black))
	if tag_hap==1
,
	xscale(log)
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64")
	xtick(64000, notick)
	xtitle("")
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	legend(off)
	xsize(10) ysize(7.5)
	name(eurob_hap, replace)
;
#delimit cr

#delimit ;
graph combine eurob_hap eurob_sat,
	rows(1)
	title("Eurobarometer, 2006", size(medium))
	imargin(zero)
	xsize(10) ysize(7.5)
	name(eurob, replace)
;
#delimit cr


*** Make six panel graph
#delimit ;
graph combine kettering euroqol eurob, 
	rows(3)
	xcommon
	l1title("Ordered probit index", size(small))
	b1title("Real GDP per capita (thousands of dollars, log scale)", size(vsmall))
	title("   Happiness                      Life satisfaction", size(medlarge))
	imargin(zero)
	xsize(7.5) ysize(10)
	name(fig6, replace)
;
#delimit cr



